
$DoorCloseTime = 1;


// HANDLES ALL DOOR CLOSING FUNCTIONALITY
function CloseDoorEnter(%data, %doorType)
{
   // get the character leaving the work building
   %object = GetThisObject(%data);
   %character = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == false)
   {
      return;
   }
   
   // get the building for the character
   %building = 0;
   switch (%doorType)
   {
   case $DoorWork:
      %building = %character.getWork();
   case $DoorHome:
      %building = %character.getHome();
   case $DoorHide:
      %building = %character.getCover();
   case $DoorTarget:
      %building = GetParameterTarget(%data);
   }
   if (isObject(%building) == false)
   {
      return;
   }
   
   // check if the door needs to close and update the number of
   // times this door has been opened
   %building.doorOpenCount--;
   if (%building.doorOpenCount == 0)
   {
      %building.playThread(1, "closedoor");
   }
}

function CloseDoorUpdate(%data)
{
   ReturnValue(%data, 0);
   
   /*
   %timePassed = TimeInNode(%data);
   if (%timePassed >= $DoorCloseTime)
   {
      ReturnValue(%data, 0);
   }
   else
   {
      ReturnValue(%data, -1);
   }
   */
}



// HANDLES CLOSING THE WORK DOOR
function AISMN_CloseWorkDoor::OnEnter(%this, %data)
{
   CloseDoorEnter(%data, $DoorWork);
}

function AISMN_CloseWorkDoor::Update(%this, %data)
{
   CloseDoorUpdate(%data);
}



// HANDLES CLOSING THE HOME DOOR
function AISMN_CloseHomeDoor::OnEnter(%this, %data)
{
   CloseDoorEnter(%data, $DoorHome);
}

function AISMN_CloseHomeDoor::Update(%this, %data)
{
   CloseDoorUpdate(%data);
}



// HANDLES CLOSING THE HIDE DOOR
function AISMN_CloseHideDoor::OnEnter(%this, %data)
{
   CloseDoorEnter(%data, $DoorHide);
}

function AISMN_CloseHideDoor::Update(%this, %data)
{
   CloseDoorUpdate(%data);
}



// HANDLES CLOSING THE TARGET DOOR
function AISMN_CloseTargetDoor::OnEnter(%this, %data)
{
   CloseDoorEnter(%data, $DoorTarget);
}

function AISMN_CloseTargetDoor::Update(%this, %data)
{
   CloseDoorUpdate(%data);
}
